<?php
// +------------------------------------------------------------------------+
// | PHP Melody ( www.phpsugar.com )
// +------------------------------------------------------------------------+
// | PHP Melody IS NOT FREE SOFTWARE
// | If you have downloaded this software from a website other
// | than www.phpsugar.com or if you have received
// | this software from someone who is not a representative of
// | PHPSUGAR, you are involved in an illegal activity.
// | ---
// | In such case, please contact: support@phpsugar.com.
// +------------------------------------------------------------------------+
// | Developed by: PHPSUGAR (www.phpsugar.com) / support@phpsugar.com
// | Copyright: (c) 2004-2013 PHPSUGAR. All rights reserved.
// +------------------------------------------------------------------------+

class resize_img
{
  // holds the image path
  var $image_path = '';
  
  // the limit of the image width
  var $sizelimit_x = 100;
  
  // the limit of the image height
  var $sizelimit_y = 100;
  
  // holds the image resource
  var $image_resource = null;
  
  // if true it keeps the image proportions when resized
  var $keep_proportions = true;
  
  // holds the resized image resource
  var $resized_resource = null;
  
  var $gdlib = false;
  
  var $output = 'SAMETYPE'; // can be JPG, GIF, PNG, or SAMETYPE 
  
  var $error = '';
  
  var $quality = 85; // جودة الصورة للصيغ التي تدعم الضغط
  
  function __construct()
  {
    if(function_exists('gd_info'))
    { 
        $this->gdlib = true; 
    }
  }
  
  function resize_image($image_path)
  {
    // no GD installed on the server!
    if($this->gdlib === false)
    {
        $this->error = 'GD doesn\'t seem to be present.'; 
        return false; 
    }
    
    // this is going to get the image width, height, and format
    list($img_width, $img_height, $img_type) = @getimagesize($image_path);

    // make sure it was loaded correctly
    if($img_width === 0 || $img_height === 0)
    { 
        $this->error = 'Invalid image dimensions.';
        return false;
    }
    
    // load image based on type
    switch($img_type)
    {
        case IMAGETYPE_GIF:
            $this->image_resource = @imagecreatefromgif($image_path);
            if($this->output == 'SAMETYPE')
            { 
                $this->output = 'GIF'; 
            }
            break;
        case IMAGETYPE_JPEG:
            $this->image_resource = @imagecreatefromjpeg($image_path);
            if($this->output == 'SAMETYPE')
            {
                $this->output = 'JPG';
            }
            break;  
        case IMAGETYPE_PNG:
            $this->image_resource = @imagecreatefrompng($image_path);
            if($this->output == 'SAMETYPE')
            { 
                $this->output = 'PNG'; 
            }
            break;
        default:
            $this->error = 'Unsupported image format.';
            return false;
    }
    
    if(!$this->image_resource)
    {
        $this->error = 'Can\'t read image source. Not an image?';
        return false;
    }
    
    // calculate new dimensions
    if($this->keep_proportions)
    {
        $ratio = min($this->sizelimit_x / $img_width, $this->sizelimit_y / $img_height);
        $new_width = (int)($img_width * $ratio);
        $new_height = (int)($img_height * $ratio);
    }
    else
    {
        $new_width = min($this->sizelimit_x, $img_width);
        $new_height = min($this->sizelimit_y, $img_height);
    }
    
    // create new image resource
    $this->resized_resource = @imagecreatetruecolor($new_width, $new_height);
    
    // handle transparency for PNG and GIF
    if($this->output === 'PNG' || $this->output === 'GIF')
    {
        imagealphablending($this->resized_resource, false);
        imagesavealpha($this->resized_resource, true);
        $transparent = imagecolorallocatealpha($this->resized_resource, 255, 255, 255, 127);
        imagefilledrectangle($this->resized_resource, 0, 0, $new_width, $new_height, $transparent);
    }
    else
    {
        // white background for JPG
        $white = imagecolorallocate($this->resized_resource, 255, 255, 255);
        imagefilledrectangle($this->resized_resource, 0, 0, $new_width, $new_height, $white);
    }
    
    // resample image
    imagecopyresampled(
        $this->resized_resource, 
        $this->image_resource, 
        0, 0, 0, 0, 
        $new_width, $new_height, 
        $img_width, $img_height
    );
    
    // destroy old image resource    
    @imagedestroy($this->image_resource);

    return true;
  }
  
  function save_resizedimage($path, $name)
  {
    // تأكد من أن المسار ينتهي بـ /
    $path = rtrim($path, '/') . '/';
    
    // إنشاء المجلد إذا لم يكن موجوداً
    if (!is_dir($path)) {
        mkdir($path, 0755, true);
    }
    
    switch(strtoupper($this->output))
    {
        case 'GIF':
            @imagegif($this->resized_resource, $path . $name . '.gif');
            break;
        case 'JPG':
            @imagejpeg($this->resized_resource, $path . $name . '.jpg', $this->quality);
            break;  
        case 'PNG':
            @imagepng($this->resized_resource, $path . $name . '.png');
            break;
    }
  }
  
  function output_resizedimage()
  {
    $the_time = time();
    header('Last-Modified: ' . date('D, d M Y H:i:s', $the_time) . ' GMT'); 
    header('Cache-Control: public');

    switch(strtoupper($this->output))
    {
        case 'GIF':
            header('Content-type: image/gif');
            @imagegif($this->resized_resource);
            break;
        case 'JPG':
            header('Content-type: image/jpeg');
            @imagejpeg($this->resized_resource, null, $this->quality);
            break;  
        case 'PNG':
            header('Content-type: image/png');
            @imagepng($this->resized_resource);
            break;
    }
  }
  
  function destroy_resizedimage()
  {
    if($this->resized_resource) {
        @imagedestroy($this->resized_resource);
    }
    if($this->image_resource) {
        @imagedestroy($this->image_resource);
    }
  }
}

?>