<?php
require_once('../config.php');
require_once('../include/functions.php');

header('Content-Type: application/json');
ini_set('display_errors', 0);
ini_set('log_errors', 1);

$conn = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
if (!$conn) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'فشل الاتصال بقاعدة البيانات']);
    exit;
}

$video_id = $_GET['video_id'] ?? '';

if (empty($video_id)) {
    echo json_encode(['success' => false, 'message' => 'Missing video_id']);
    exit;
}

$sql = "SELECT COUNT(*) as total_votes, AVG(rating) as average_rating FROM video_ratings WHERE video_id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'فشل تجهيز الاستعلام']);
    exit;
}

$stmt->bind_param("s", $video_id);
if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'فشل تنفيذ الاستعلام']);
    exit;
}

// استبدال get_result باستقبال النتائج عبر bind_result
$stmt->store_result();
$total_votes = 0; $average_rating = null;
$stmt->bind_result($total_votes, $average_rating);
$stmt->fetch();
$stmt->close();

echo json_encode([
    'success' => true,
    'total_votes' => (int)$total_votes,
    'average_rating' => $average_rating === null ? 0 : round((float)$average_rating, 1)
]);
?>