<?php
session_start();
ini_set('display_errors', 0);
ini_set('log_errors', 1);
header('Content-Type: application/json; charset=utf-8');
require('../config.php');

$video_id = $_GET['vid'] ?? '';
if (empty($video_id)) {
  echo json_encode(['success'=>false,'error'=>'Missing vid']);
  exit;
}

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) {
  echo json_encode(['success'=>false,'error'=>'DB connection failed']);
  exit;
}
$conn->set_charset('utf8mb4');

$stmt = $conn->prepare("
  SELECT
    COALESCE(SUM(action='like'),0)    AS likes,
    COALESCE(SUM(action='dislike'),0) AS dislikes
  FROM video_likes
  WHERE video_id = ?
");
if (!$stmt) {
  error_log("Prepare failed: " . $conn->error);
  echo json_encode(['success'=>false,'error'=>'DB query failed']);
  exit;
}
$stmt->bind_param("s", $video_id);
if (!$stmt->execute()) {
  error_log("Execute failed: " . $stmt->error);
  echo json_encode(['success'=>false,'error'=>'DB execute failed']);
  exit;
}

// استخدم bind_result بدلاً من get_result
$stmt->store_result();
$likes = 0; $dislikes = 0;
$stmt->bind_result($likes, $dislikes);
$stmt->fetch();
$stmt->close();

$_SESSION['liked_videos'] = $_SESSION['liked_videos'] ?? [];
$_SESSION['disliked_videos'] = $_SESSION['disliked_videos'] ?? [];

$user_action = 'none';
if (in_array($video_id, $_SESSION['liked_videos'], true)) {
  $user_action = 'like';
} elseif (in_array($video_id, $_SESSION['disliked_videos'], true)) {
  $user_action = 'dislike';
}

echo json_encode([
  'success'     => true,
  'likes'       => (int)$likes,
  'dislikes'    => (int)$dislikes,
  'user_action' => $user_action
]);
exit;
?>