<?php
// ajax/rate_star.php

session_start();

// مكان ملف اللوج (تأكد أن المجلد قابل للكتابة)
$logFile = __DIR__ . '/debug_rate_star.log';

// دالة للكتابة في اللوج
function debugLog($msg) {
    global $logFile;
    $time = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$time] $msg\n", FILE_APPEND);
}

// 1) سجل نقطة البداية
debugLog("=== New RATE_STAR Request ===");
$rawInput = file_get_contents('php://input');
debugLog("Raw Input: " . $rawInput);

// 2) تضمين إعدادات قاعدة البيانات
require_once(__DIR__ . '/../config.php');

// 3) تهيئة اتصال قاعدة البيانات
$conn = mysqli_connect($db_host, $db_user, $db_pass, $db_name);
if (!$conn) {
    debugLog("DB connect error: " . mysqli_connect_error());
    http_response_code(500);
    echo json_encode(['success'=>false, 'message'=>'فشل الاتصال بقاعدة البيانات']);
    exit;
}

// 4) قراءة وفك تشفير JSON من body
$data = json_decode($rawInput, true);
debugLog("Decoded JSON: " . var_export($data, true));

$video_id = $data['video_id'] ?? '';
$rating   = isset($data['rating']) ? (int)$data['rating'] : 0;
$ip       = $_SERVER['REMOTE_ADDR'];
debugLog("Parsed video_id={$video_id}, rating={$rating}, ip={$ip}");

// 5) التحقق من المدخلات
if (empty($video_id) || $rating < 1 || $rating > 5) {
    debugLog("Invalid input detected");
    http_response_code(400);
    echo json_encode(['success'=>false, 'message'=>'Invalid input']);
    exit;
}

// 6) منع التقييم المكرر من نفس الـ IP
$check = $conn->prepare("SELECT id FROM video_ratings WHERE video_id = ? AND ip_address = ?");
if (!$check) {
    debugLog("Prepare failed (SELECT): " . $conn->error);
    http_response_code(500);
    echo json_encode(['success'=>false, 'message'=>'Database error']);
    exit;
}
$check->bind_param("ss", $video_id, $ip);
$check->execute();
$res = $check->get_result();
debugLog("Duplicate check, rows found: " . $res->num_rows);
if ($res->num_rows > 0) {
    debugLog("Duplicate attempt prevented");
    echo json_encode(['success'=>false, 'message'=>'Duplicate']);
    exit;
}
$check->close();

// 7) إدراج التقييم
$stmt = $conn->prepare("INSERT INTO video_ratings (video_id, rating, ip_address) VALUES (?, ?, ?)");
if (!$stmt) {
    debugLog("Prepare failed (INSERT): " . $conn->error);
    http_response_code(500);
    echo json_encode(['success'=>false, 'message'=>'Database error']);
    exit;
}
$stmt->bind_param("sis", $video_id, $rating, $ip);
$execOk = $stmt->execute();
debugLog("Insert executed: " . ($execOk ? 'OK' : 'Failed: ' . $stmt->error));
$stmt->close();

// 8) إرجاع النتيجة
echo json_encode([
    'success' => (bool)$execOk,
    'message' => $execOk ? 'Rated successfully' : 'Failed'
]);

debugLog("=== End RATE_STAR Request ===\n");
exit;
