<?php
class ApcuCache {
    public function get($key) {
        if (function_exists('apcu_fetch')) {
            return apcu_fetch($key);
        }
        return null;
    }

    public function set($key, $value, $ttl = 300) {
        if (function_exists('apcu_store')) {
            apcu_store($key, $value, $ttl);
        }
    }

    public function delete($key) {
        if (function_exists('apcu_delete')) {
            apcu_delete($key);
        }
    }
}

