{* ======================================================= *}
{*             1. تضمين الهيدر (Header)                  *}
{* ======================================================= *}
{include file="header.tpl" p="detail" tpl_name="video-watch"}

{* ======================================================= *}
{*       2. JSON-LD لبيانات VideoObject (SEO)            *}
{*    هذه الشفرة تُرسل لمحركات البحث وصف الفيديو كامل    *}
{* ======================================================= *}
{if $schema_video_json}
  <script type="application/ld+json">
    {$schema_video_json nofilter}
  </script>
{/if}

{* ======================================================= *}
{*    3. JSON-LD لبيانات Breadcrumbs (SEO)               *}
{*    يضمن لمحركات البحث فهم مسار التنقل الصحيح          *}
{* ======================================================= *}
{if $schema_breadcrumb}
  <script type="application/ld+json">
    {$schema_breadcrumb nofilter}
  </script>
{/if}

{* ======================================================= *}
{* 4. القسم المظلل بخلفية صورة الفيديو (Highlighted)     *}
{* ======================================================= *}
<div class="pm-section-highlighted">
  <div class="container-fluid">
    <div class="row">
      {* ------------------------------------------------------- *}
      {* 4.1. رسالة تحذير عند عرض فيديو محذوف للمشرف (Admin)    *}
      {* ------------------------------------------------------- *}
      {if $logged_in && $is_admin == 'yes' && $video_data.in_trash}
        <div class="alert alert-warning">
          {$lang.viewing_deleted_video}
        </div>
      {/if}

      <div class="container">
        <div class="row pm-video-heading">

          {* =================================================== *}
          {* 5. شريط التنقل للمستخدم (Breadcrumbs – HTML)       *}
          {* =================================================== *}
          <div class="col-xs-12 col-sm-12 col-md-8">
            <ul class="breadcrumbNav">
              {foreach from=$breadcrumbs item=bc name=bcLoop}
                <li class="breadcrumb-item {if $smarty.foreach.bcLoop.last}active{/if}">
                  {if !$smarty.foreach.bcLoop.last}
                    <a href="{$bc.url}">{$bc.name}</a>
                  {else}
                    <span>{$bc.name}</span>
                  {/if}
                </li>
              {/foreach}
            </ul>

            {* =================================================== *}
            {* 6. عنوان الفيديو والوصف المبسط                    *}
            {* =================================================== *}
            <h1>{$video_data.video_title}</h1>
            {if $playlist}
              <h6>
                {$lang.from_playlist|default:'This video is part of the %s playlist.'|sprintf:$playlist.title}
              </h6>
            {/if}
          </div>

          {* =================================================== *}
          {* 7. أزرار الإدارة (للمشرفين فقط)                   *}
          {* =================================================== *}
          <div class="hidden-xs hidden-sm col-md-4">
            <div class="pm-video-adjust btn-group">
              {if $logged_in && $is_admin == 'yes' && ! $video_data.in_trash}
                {if $myID}
                  <a href="{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-episode.php?episode_id={$myID}"
                     class="btn btn-sm btn-default" rel="tooltip"
                     title="{$lang.edit} ({$lang._admin_only})" target="_blank">
                    {$lang.edit}
                  </a>
                {else}
                  <a href="{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-video.php?vid={$video_data.uniq_id}"
                     class="btn btn-sm btn-default" rel="tooltip"
                     title="{$lang.edit} ({$lang._admin_only})" target="_blank">
                    {$lang.edit}
                  </a>
                {/if}
                <a href="#"
                   onclick="return confirm_action(pm_lang.delete_video_confirmation,
                     '{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-video.php?vid={$video_data.uniq_id}&a=3');"
                   class="btn btn-sm btn-danger" rel="tooltip"
                   title="{$lang.trash|default:'Trash'} ({$lang._admin_only})" target="_blank">
                  {$lang.trash|default:'Trash'}
                </a>
              {/if}
            </div>
          </div>

        </div><!-- /.pm-video-watch-heading -->

        {* =================================================== *}
        {* 8. مشغل الفيديو الرئيسي                            *}
        {* =================================================== *}
        <div class="row">
          <div id="player" class="col-xs-12 col-sm-12 col-md-12 wide-player">
            <div id="video-wrapper">
              <div id="BiBplayer" status="preview" class="video-bibplayer">
                <div class="video-bibplayer-poster" loading="lazy"
                     style="background-image: url({$video_data.thumb_img_url});"></div>
                <div class="video-bibplayer-video"></div>
                <a class="xtgo" href="{$watchUrl}" rel="nofollow">
                  {if $video_data.type != "series"}
                    {* عناصر التحكم في التشغيل (Play/Pause، شريط التقدم…) *}
                    <div class="controls-play-pause-big" data-control="play-pause" playing="paused">
                      <div class="icon-play"><span></span></div>
                    </div>
                    <div class="controls" data-control="controls-container">
                      <span class="controls-progress-bar">
                        <span class="controls-progress-bar-value"
                              data-control="progress-bar-value"></span>
                      </span>
                      <span class="controls-play-pause" data-control="play-pause" playing="paused"></span>
                      <span class="controls-time">
                        <span class="xtraprogress" data-control="time" style="display: block;">
                          <i>{$video_data.duration}</i>
                        </span>
                      </span>
                      <span class="controls-full-screen" data-control="full-screen"></span>
                      <span class="controls-volume" data-control="volume">
                        <span class="controls-volume-value"
                              data-control="volume-value" style="width: 70%;"></span>
                      </span>
                      <span class="controls-mute" data-control="mute"></span>
                    </div>
                  {/if}
                </a>
              </div>
            </div>
          </div>
        </div>

        {* =================================================== *}
        {* 9. روابط الحلقة السابقة والتالية                   *}
        {* =================================================== *}
        {if $prevEpUrl || $nextEpUrl}
          <div class="wrapper-eps">
            <div class="row">
              <div class="col-eps col-xs-12 col-sm-12 col-md-12">
                {if $prevEpUrl}
                  <div class="prev_ep">
                    <a href="{$smarty.const._URL}/watch.php?vid={$prevEpUrl}">
                      <i class="fa fa-chevron-circle-right"></i>
                      الحلقة السابقة <span>{$prevEp}</span>
                    </a>
                  </div>
                {/if}
                {if $nextEpUrl}
                  <div class="next_ep">
                    <a href="{$smarty.const._URL}/watch.php?vid={$nextEpUrl}">
                      <i class="fa fa-chevron-circle-left"></i>
                      الحلقة التالية <span>{$nextEp}</span>
                    </a>
                  </div>
                {/if}
              </div>
            </div>
          </div>
        {/if}

      </div><!-- /.container -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div><!-- /.pm-section-highlighted -->

{include file='video-tool-box.tpl'}

{* ======================================================= *}
{*   10. قسم التحميلات والمواسم (Downloads & Seasons)     *}
{* ======================================================= *}
{* 10. قسم التحميلات والمواسم *}
{if $downloads || $series_data}

  <div class="container content-series-page content-series-onwatch" style="margin-top:20px !important;">

    {* 1) زرّ التحميل *}
    {if $downloads}
      <div class="container-fluid download-sec">
        <div class="row">
          <div id="btnServers">
            <a class="btnDowns"
               href="{$smarty.const._URL2}/downloads.php?vid={$video_data.uniq_id}"
               rel="nofollow">
              اضغط هنا للذهاب الي سيرفرات التحميل
            </a>
          </div>
        </div>
      </div>
    {/if}

    {* 2) مواسم وحلقات المسلسل *}
    {if $series_data}
      <div class="container-fluid">
        <div class="row">
          <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true" style="margin-top:20px !important;">
            <div class="col-md-12 serie_eps">
              <div class="mbox">
                
                {* عنوان القسم *}
                <div class="pda bdb hd">
                  <right style="font-size: 20px;
                                color: #000;
                                padding: 5px 10px;
                                margin-top: 10px;
                                font-weight: bold;">
                    المواسم و الحلقات
                  </right>
                </div>
                
                <div class="SeasonsBox">
                  
                  {* 2.1) أزرار المواسم *}
                  <div class="SeasonsBoxUL seasons-serie">
                    <div class="Tab">
                      {foreach from=$seasons_data key=season_no item=season name=seasons_loop}
                        <button
                          class="tablinks{if $season == $video_data.season} active{/if}"
                          onclick="openCity(event, 'Season{$season_no+1}')">
                          {$season}
                        </button>
                      {/foreach}
                    </div>
                  </div>
                  
                  {* 2.2) عرض الحلقات بناءً على الموسم المحدّد *}
                  <div class="SeasonsEpisodesMain">
                    <div class="Tab" style="color: black;">
                      {$seasons_episodes}
                    </div>
                  </div>
                  
                </div>
              
              </div>
            </div>
          </div>
        </div>
      </div>
    {/if}

  </div>

{/if}

{* ======================================================= *}
{*    11. المحتوى الرئيسي والتعليقات (Comments Section)   *}
{* ======================================================= *}
<div id="content">
  <div id="content-main" class="container-fluid">
    <div class="row">
      <div class="col-xs-12 col-sm-12 col-md-12 pm-video-watch-main">

        {* 11.1 إعلان داخل المحتوى إن وجد *}
        {if $ad_3 != ''}
          <div class="pm-ads-banner" align="center">{$ad_3}</div>
        {/if}

        {* 11.2 هيدر المستخدم: الصورة، اسم الكاتب، وقت الإضافة *}
        <div class="row pm-user-header">
          <div class="col-xs-2 col-sm-1 col-md-1">
            <a href="{$video_data.author_profile_href}">
              <img src="{$video_data.author_avatar_url}" height="60" width="60" alt="">
            </a>
            {if $video_data.author_data.channel_verified == 1 && $smarty.const._MOD_SOCIAL}
              <a href="#" rel="tooltip" title="{$lang.verified_channel}"
                 class="pm-verified-user">
                <img src="{$smarty.const._URL}/templates/{$smarty.const._TPLFOLDER}/img/ico-verified.png" />
              </a>
            {/if}
          </div>
          <div class="col-xs-10 col-sm-11 col-md-11">
            <div class="pm-video-posting-info">
              {$lang.added}
              <time datetime="{$video_data.html5_datetime}" title="{$video_data.full_datetime}">
                {$video_data.time_since_added} {$lang.ago}
              </time>
              {$lang._by}
              <a href="{$video_data.author_profile_href}">{$video_data.author_username}</a>
            </div>
            {if $smarty.const._MOD_SOCIAL && $logged_in == '1' && $video_data.author_user_id != $s_user_id}
              {include file="user-subscribe-button.tpl"
                       profile_data=$video_data
                       profile_user_id=$video_data.author_user_id}
            {/if}
          </div>
        </div><!--/.pm-user-header-->

        {* 11.3 وصف الفيديو والتفاصيل (Description & Details) *}
        <div class="pm-video-description mbox">
          <div class="pda bdb hd">
            <right style="font-size:20px;color:#000;padding:5px 10px;margin-top:10px;font-weight:bold;">
              الوصف والتفاصيل
            </right>
          </div>
          <div class="description">
            {if !empty($video_data.description)}
              <div>{$video_data.description}</div>
            {/if}
            <dl class="dl-horizontal">
              {if !empty($video_data.series)}
                <dt>المسلسل</dt><dd>{$video_data.series}</dd>
              {/if}
              {if !empty($video_data.season)}
                <dt>الموسم</dt><dd>{$video_data.season}</dd>
              {/if}
              {if !empty($category_name)}
                <dt>الأقسام</dt><dd>{$category_name}</dd>
              {/if}
              {if !empty($tags)}
                <dt>الكلمات المفتاحية</dt><dd>{$tags}</dd>
              {/if}
            </dl>
          </div>
        </div>

        {* 11.4 قسم التعليقات *}
        {include file="comments.tpl" tpl_name="video-watch" allow_comments=$video_data.allow_comments}

      </div><!-- /pm-video-watch-main -->
    </div><!-- /.row -->
  </div><!-- /#content-main -->
</div><!-- /#content -->

{* ======================================================= *}
{*   12. الفيديوهات المرتبطة والمجموعات (Collections)     *}
{* ======================================================= *}
{if $collection}

    <div class="container" style="margin-top:10px;">
        <div class="SeasonsBoxUL seasons-on-serie" style="margin-top: 10px"> <p class="seasonEp">{$video_data.collection}</p> </div>
        <ul class="row pm-ul-browse-videos list-unstyled" id="pm-grid">
            {foreach from=$collection key=k item=video_data}
                <li class="col-xs-6 col-sm-4 col-md-3">
                    {include file='item-video-obj.tpl'}
                </li>
            {/foreach}
        </ul>    
    </div>
{/if}                       
                        
{if $related_video_list}
    <div class="container" style="margin-top:10px;">
        <div class="SeasonsBoxUL seasons-on-serie" style="margin-top: 10px"> <p class="seasonEp">قد تود مشاهدتها</p> </div>
        <ul class="row pm-ul-browse-videos list-unstyled" id="pm-grid">
             {foreach from=$related_video_list key=k item=video_data}
                <li class="col-xs-6 col-sm-4 col-md-3">
                    {include file='item-video-obj.tpl'}
                </li>
            {/foreach}
        </ul>    
    </div>
{/if}  
{* ======================================================= *}
{*       13. النوافذ المنبثقة (Modals)                     *}
{* ======================================================= *}
{include file="modal-video-report.tpl"}
{include file="modal-video-addtoplaylist.tpl"}

{* ======================================================= *}
{*       14. تضمين الفوتر (Footer)                        *}
{* ======================================================= *}
{include file="footer.tpl" p="detail" tpl_name="video-watch"}
