/* Project: Bootstrap Notify = v3.1.3 * Description: Turns standard Bootstrap alerts into "Growl-like" notifications. * Author: Mouse0270 aka Robert McIntosh * License: MIT License * Website: https://github.com/mouse0270/bootstrap-growl */
(function(c) { "function" === typeof define && define.amd ? define(["jquery"], c) : "object" === typeof exports ? c(require("jquery")) : c(jQuery) })(function(c) {
    function h(a, b, e) {
        b = { content: { message: "object" == typeof b ? b.message : b, title: b.title ? b.title : "", icon: b.icon ? b.icon : "", url: b.url ? b.url : "#", target: b.target ? b.target : "-" } };
        e = c.extend(!0, {}, b, e);
        this.settings = c.extend(!0, {}, g, e);
        this._defaults = g;
        "-" == this.settings.content.target && (this.settings.content.target = this.settings.url_target);
        this.animations = {
            start: "webkitAnimationStart oanimationstart MSAnimationStart animationstart",
            end: "webkitAnimationEnd oanimationend MSAnimationEnd animationend"
        };
        "number" == typeof this.settings.offset && (this.settings.offset = { x: this.settings.offset, y: this.settings.offset });
        this.init()
    }
    var g = {
        element: "body",
        position: null,
        type: "info",
        allow_dismiss: !0,
        newest_on_top: !1,
        showProgressbar: !1,
        placement: { from: "top", align: "right" },
        offset: 20,
        spacing: 10,
        z_index: 1031,
        delay: 5E3,
        timer: 1E3,
        url_target: "_blank",
        mouse_over: null,
        animate: { enter: "animated bounceInRight", exit: "animated bounceOutRight" },
        onShow: null,
        onShown: null,
        onClose: null,
        onClosed: null,
        icon_type: "class",
        template: '<div data-notify="container" class="col-xs-11 col-sm-4 alert alert-{0}" role="alert"><button type="button" aria-hidden="true" class="close" data-notify="dismiss">&times;</button><span data-notify="icon"></span> <span data-notify="title">{1}</span> <span data-notify="message">{2}</span><div class="progress" data-notify="progressbar"><div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div></div><a href="{3}" target="{4}" data-notify="url"></a></div>',
        PM_exitAnimationTimeout: 0
    };
    String.format = function() { for (var a = arguments[0], b = 1; b < arguments.length; b++) a = a.replace(RegExp("\\{" + (b - 1) + "\\}", "gm"), arguments[b]); return a };
    c.extend(h.prototype, {
        init: function() {
            var a = this;
            this.buildNotify();
            this.settings.content.icon && this.setIcon();
            "#" != this.settings.content.url && this.styleURL();
            this.placement();
            this.bind();
            this.notify = {
                $ele: this.$ele,
                update: function(b, c) {
                    var d = {};
                    "string" == typeof b ? d[b] = c : d = b;
                    for (b in d) switch (b) {
                        case "type":
                            this.$ele.removeClass("bg-" +
                                a.settings.type);
                            this.$ele.find('[data-notify="progressbar"] > .progress-bar').removeClass("progress-bar-" + a.settings.type);
                            a.settings.type = d[b];
                            this.$ele.addClass("bg-" + d[b]).find('[data-notify="progressbar"] > .progress-bar').addClass("progress-bar-" + d[b]);
                            break;
                        case "icon":
                            var f = this.$ele.find('[data-notify="icon"]');
                            "class" == a.settings.icon_type.toLowerCase() ? f.removeClass(a.settings.content.icon).addClass(d[b]) : (f.is("img") || f.find("img"), f.attr("src", d[b]));
                            break;
                        case "progress":
                            this.$ele.data("notify-delay",
                                a.settings.delay - d[b] / 100 * a.settings.delay);
                            this.$ele.find('[data-notify="progressbar"] > div').attr("aria-valuenow", d[b]).css("width", d[b] + "%");
                            break;
                        case "url":
                            this.$ele.find('[data-notify="url"]').attr("href", d[b]);
                            break;
                        case "target":
                            this.$ele.find('[data-notify="url"]').attr("target", d[b]);
                            break;
                        default:
                            this.$ele.find('[data-notify="' + b + '"]').html(d[b])
                    }
                    d = this.$ele.outerHeight() + parseInt(a.settings.spacing) + parseInt(a.settings.offset.y);
                    a.reposition(d)
                },
                close: function() { a.close() }
            }
        },
        buildNotify: function() {
            var a =
                this.settings.content;
            this.$ele = c(String.format(this.settings.template, this.settings.type, a.title, a.message, a.url, a.target));
            this.$ele.attr("data-notify-position", this.settings.placement.from + "-" + this.settings.placement.align);
            this.settings.allow_dismiss || this.$ele.find('[data-notify="dismiss"]').css("display", "none");
            (0 >= this.settings.delay && !this.settings.showProgressbar || !this.settings.showProgressbar) && this.$ele.find('[data-notify="progressbar"]').remove()
        },
        setIcon: function() {
            "class" == this.settings.icon_type.toLowerCase() ?
                this.$ele.find('[data-notify="icon"]').addClass(this.settings.content.icon) : this.$ele.find('[data-notify="icon"]').is("img") ? this.$ele.find('[data-notify="icon"]').attr("src", this.settings.content.icon) : this.$ele.find('[data-notify="icon"]').append('<img src="' + this.settings.content.icon + '" alt="Notify Icon" />')
        },
        styleURL: function() {
            this.$ele.find('[data-notify="url"]').css({
                backgroundImage: "url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)",
                height: "100%",
                left: "0px",
                position: "absolute",
                top: "0px",
                width: "100%",
                zIndex: this.settings.z_index + 1
            });
            this.$ele.find('[data-notify="dismiss"]').css({ position: "absolute", right: "10px", top: "5px", zIndex: this.settings.z_index + 2 })
        },
        placement: function() {
            var a = this,
                b = this.settings.offset.y,
                e = { display: "inline-block", margin: "0px auto", position: this.settings.position ? this.settings.position : "body" === this.settings.element ? "fixed" : "absolute", transition: "all .5s ease-in-out", zIndex: this.settings.z_index },
                d = !1,
                f = this.settings;
            c('[data-notify-position="' +
                this.settings.placement.from + "-" + this.settings.placement.align + '"]:not([data-closing="true"])').each(function() { return b = Math.max(b, parseInt(c(this).css(f.placement.from)) + parseInt(c(this).outerHeight()) + parseInt(f.spacing)) });
            1 == this.settings.newest_on_top && (b = this.settings.offset.y);
            e[this.settings.placement.from] = b + "px";
            switch (this.settings.placement.align) {
                case "left":
                case "right":
                    e[this.settings.placement.align] = this.settings.offset.x + "px"; break;
                case "center":
                    e.left = 0, e.right = 0 } this.$ele.css(e).addClass(this.settings.animate.enter);
            c.each(["webkit", "moz", "o", "ms", ""], function(b, c) { a.$ele[0].style[c + "AnimationIterationCount"] = 1 });
            c(this.settings.element).append(this.$ele);
            1 == this.settings.newest_on_top && (b = parseInt(b) + parseInt(this.settings.spacing) + this.$ele.outerHeight(), this.reposition(b));
            c.isFunction(a.settings.onShow) && a.settings.onShow.call(this.$ele);
            this.$ele.one(this.animations.start, function(a) { d = !0 }).one(this.animations.end, function(b) { c.isFunction(a.settings.onShown) && a.settings.onShown.call(this) });
            setTimeout(function() {
                d ||
                    c.isFunction(a.settings.onShown) && a.settings.onShown.call(this)
            }, a.settings.PM_exitAnimationTimeout)
        },
        bind: function() {
            var a = this;
            this.$ele.find('[data-notify="dismiss"]').on("click", function() { a.close() });
            this.$ele.mouseover(function(a) { c(this).data("data-hover", "true") }).mouseout(function(a) { c(this).data("data-hover", "false") });
            this.$ele.data("data-hover", "false");
            if (0 < this.settings.delay) {
                a.$ele.data("notify-delay", a.settings.delay);
                var b = setInterval(function() {
                    var c = parseInt(a.$ele.data("notify-delay")) -
                        a.settings.timer;
                    if ("false" === a.$ele.data("data-hover") && "pause" == a.settings.mouse_over || "pause" != a.settings.mouse_over) { var d = (a.settings.delay - c) / a.settings.delay * 100;
                        a.$ele.data("notify-delay", c);
                        a.$ele.find('[data-notify="progressbar"] > div').attr("aria-valuenow", d).css("width", d + "%") } c <= -a.settings.timer && (clearInterval(b), a.close())
                }, a.settings.timer)
            }
        },
        close: function() {
            var a = this,
                b = parseInt(this.$ele.css(this.settings.placement.from)),
                e = !1;
            this.$ele.data("closing", "true").addClass(this.settings.animate.exit);
            a.reposition(b);
            c.isFunction(a.settings.onClose) && a.settings.onClose.call(this.$ele);
            this.$ele.one(this.animations.start, function(a) { e = !0 }).one(this.animations.end, function(b) { c(this).remove();
                c.isFunction(a.settings.onClosed) && a.settings.onClosed.call(this) });
            setTimeout(function() { if (!e && (a.$ele.remove(), a.settings.onClosed)) a.settings.onClosed(a.$ele) }, a.settings.PM_exitAnimationTimeout)
        },
        reposition: function(a) {
            var b = this,
                e = '[data-notify-position="' + this.settings.placement.from + "-" + this.settings.placement.align +
                '"]:not([data-closing="true"])',
                d = this.$ele.nextAll(e);
            1 == this.settings.newest_on_top && (d = this.$ele.prevAll(e));
            d.each(function() { c(this).css(b.settings.placement.from, a);
                a = parseInt(a) + parseInt(b.settings.spacing) + c(this).outerHeight() })
        }
    });
    c.notify = function(a, b) { return (new h(this, a, b)).notify };
    c.notifyDefaults = function(a) { return g = c.extend(!0, {}, g, a) };
    c.notifyClose = function(a) {
        "undefined" === typeof a || "all" == a ? c("[data-notify]").find('[data-notify="dismiss"]').trigger("click") : c('[data-notify-position="' +
            a + '"]').find('[data-notify="dismiss"]').trigger("click")
    }
});