{include file='header.tpl' p="general" tpl_name="video-series"}

<div id="content">
	<div id="category-header" class="container-fluid">
		{if $genres.$genre_id.child_count > 0}
			<div class="row pm-category-header-subcats">
				<div class="col-md-12">
					<div class="pm-section-head">
					<h2>{$lang.related_genres|default:"Related Genres"}</h2>
						<div class="btn-group btn-group-sort">
							<button class="btn btn-xs" id="pm-slide-prev_subcategories"><i class="fa fa-chevron-left"></i></button>
							<button class="btn btn-xs" id="pm-slide-next_subcategories"><i class="fa fa-chevron-right"></i></button>
						</div>
					</div>
					<ul class="pm-ul-carousel-videos list-inline pm-ul-browse-subcategories thumbnails mt-3" data-slider-id="subcategories" data-slides="5" id="pm-carousel_subcategories">
					{foreach from=$genres item=genre_array name=genres_items_loop}
						{if $genre_array.parent_id == $genre_id}
						<li>
							<div class="pm-li-category">
								<a href="{$genre_array.url}">
									<h3>{$genre_array.name|truncate:32}</h3>
								</a>
							</div>
						</li>
						{/if}
					{/foreach}
					</ul>
				</div>
			</div>
		{/if}
	</div>

	<div class="container-fluid">
		<div class="row">
		<div class="col-md-12">
		<div class="pm-section-head">
			<h2>{$lang._series}</h2>
		</div>

			{if pm_count($series) > 0}
				<ul class="pm-ul-browse-videos pm-ul-carousel-series list-unstyled d-flex flex-wrap align-content-start">
				{foreach from=$series key=k item=item_data name=series_loop}
					<li>
					{include file='item-series-obj.tpl' hideLabels='1' hideMeta='0' thumbSize='poster' isObj='series'}
					</li>
				{/foreach}
				</ul>

				{if is_array($pagination)}
					{include file='item-pagination-obj.tpl' custom_class='pagination-arrows'}
				{/if}

			{else}
				<div class="row">
					<div class="col-md-12 text-center">
						<p></p>
						<p>{$lang.browse_msg2}</p>
					</div>
				</div>
			{/if}

		</div><!-- #content -->
		</div><!-- .row -->
	</div><!-- .container -->
{include file="footer.tpl" tpl_name="video-series"}