{include file="header.tpl" p="detail" tpl_name="video-watch"}
<div class="pm-section-highlighted" style="url({$video_data.thumb_img_url});">
    <div class="container-fluid">
        <div class="row">
            {if $logged_in && $is_admin == 'yes' && $video_data.in_trash}
            <div class="alert alert-warning">
                    {$lang.viewing_deleted_video}
            </div>
            {/if}
            <div class="container">
                <div class="row pm-video-heading">
                <div class="col-xs-12 col-sm-12 col-md-8">
                    <div itemprop="video" itemscope itemtype="http://schema.org/VideoObject">
                        <ul itemscope itemtype="https://schema.org/BreadcrumbList" class="breadcrumbNav">
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <a itemprop="item" href="{$smarty.const._URL}">
                                    <span itemprop="name">الرئيسية</span></a>
                                    <meta itemprop="position" content="1" />
                                </li>
                                {if $catName && $catTag}
                                <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                                    <a itemprop="item" href="{$smarty.const._URL}/category.php?cat={$catTag}">
                                    <span itemprop="name">{$catName}</span></a>
                                    <meta itemprop="position" content="2" />
                                </li>
                                {/if}
                                <li><a href='{$video_data.video_href}'>{$video_data.video_title}</a></li>

                        </ul>
                        {if $playlist}
                            <h6>{$lang.from_playlist|default:'This video is part of the %s playlist.'|sprintf:$playlist.title}</h6>
                        {/if}
                            <link itemprop="url" href="{$video_data.video_href}">
                            <h1 itemprop="name">{$video_data.video_title}</h1>
                            <meta itemprop="description" content="{$meta_description}" />
                            <meta itemprop="keywords" content="{$meta_keywords}"/>
                            <meta itemprop="duration" content="{$video_data.iso8601_duration}" />
                            <meta itemprop="thumbnailUrl" content="{$video_data.thumb_img_url}" />
                            <meta itemprop="image" content="{$video_data.thumb_img_url}" />
                            <meta itemprop="contentURL" content="{$smarty.const._URL2}/videos.php?vid={$video_data.uniq_id}" />
                            <link itemprop="embedURL" href="{$video_data.embed_href}" />
                            <meta itemprop="playerType" content="HTML5 Flash">
                            <meta itemprop="width" content="640">
                            <meta itemprop="height" content="360">
                            <span itemprop="author" itemscope itemtype="https://schema.org/Person">
                            <meta itemprop="name" content="{$video_data.author_username}">
                            <link itemprop="url" href="{$video_data.author_profile_href}">
                            </span>
                            <meta itemprop="uploadDate" content="{$video_data.html5_datetime}" />
                            <meta itemprop="datePublished" content="{$video_data.html5_datetime}">
                    </div>
                </div>
                <div itemscope itemtype="http://schema.org/ImageObject">
                        <meta itemprop="image" content="{$video_data.thumb_img_url}"/>
                </div>
                <div class="hidden-xs hidden-sm col-md-4">
                        <div class="pm-video-adjust btn-group">
                            {if $logged_in && $is_admin == 'yes' && ! $video_data.in_trash}
                                {if $myID}
                                     <a href="{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-episode.php?episode_id={$myID}" class="btn btn-sm btn-default" rel="tooltip" title="{$lang.edit} ({$lang._admin_only})" target="_blank">{$lang.edit}</a> 
                                {else}
                                  <a href="{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-video.php?vid={$video_data.uniq_id}" class="btn btn-sm btn-default" rel="tooltip" title="{$lang.edit} ({$lang._admin_only})" target="_blank">{$lang.edit}</a> 
                                {/if}
                                <a href="#" onclick="return confirm_action(pm_lang.delete_video_confirmation, '{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-video.php?vid={$video_data.uniq_id}&a=3'); return false;" class="btn btn-sm btn-danger" rel="tooltip" title="{$lang.trash|default:'Trash'} ({$lang._admin_only})" target="_blank">{$lang.trash|default:'Trash'}</a>
                            {/if}
                        </div>
                </div>
                <div class="visible-mb">
                    <div class="TabS">
                            {$SMobileGenerated}
                    </div>
                    <div class="TabE">
                            {$EMobileGenerated}
                    </div>
                </div>
        </div><!-- /.pm-video-watch-heading -->

    <div class="row">
                    <div id="player" class="col-xs-12 col-sm-12 col-md-12 wide-player">
                        <div id="video-wrapper">
                            <div id="BiBplayer" status="preview" class="video-bibplayer">
                            <div class="video-bibplayer-poster" loading="lazy" style="background-image: url({$video_data.thumb_img_url});"></div>
                            <div class="video-bibplayer-video"></div>
                            <a class="xtgo" href="{$watchUrl}" rel="nofollow">
                                {if {$video_data.type} != "series"}
                                    <div class="controls-play-pause-big" data-control="play-pause" playing="paused">
                                        <div class="icon-play"><span></span></div>
                                    </div>
                                    <div class="controls" data-control="controls-container">
                                        <span class="controls-progress-bar">
                                            <span class="controls-progress-bar-value" data-control="progress-bar-value"></span>
                                        </span>
                                        <span class="controls-play-pause" data-control="play-pause" playing="paused"></span>
                                        <span class="controls-time">
                                            <span class="xtraprogress" data-control="time" style="display: block;"><i>{$video_data.duration}</i></span>
                                        </span>
                                        <span class="controls-full-screen" data-control="full-screen"></span>
                                        <span class="controls-volume" data-control="volume">
                                            <span class="controls-volume-value" data-control="volume-value" style="width: 70%;"></span>
                                        </span>
                                        <span class="controls-mute" data-control="mute"></span>
                                    </div>
                                {/if}
                            </a>
                        </div>
                    </div>
                      
                   </div>  
                    {if $prevEpUrl || $nextEpUrl}       
                       <div class="wrapper-eps">
                            <div class="row">
                                <div class="col-eps col-xs-12 col-sm-12 col-md-12">
                                    {if $prevEpUrl}
                                        <div class="prev_ep">
                                           <a href="{$smarty.const._URL}/watch.php?vid={$prevEpUrl}">
                                               <i class="fa fa-chevron-circle-right" aria-hidden="true" style="color:#E42E29"></i> الحلقة السابقة <span>{$prevEp}</span></a>
                                        </div>
                                   {/if}
                                    {if $nextEpUrl}
                                       <div class="next_ep">
                                          <a href="{$smarty.const._URL}/watch.php?vid={$nextEpUrl}">
                                              <i class="fa fa-chevron-circle-left" aria-hidden="true" style="color:#E42E29"></i> الحلقة التالية <span>{$nextEp}</span></a>
                                       </div>
                                     {/if}
                                </div>
                            </div>
                        </div>
                    {/if}
                </div> 
            </div>
        </div>
    </div>
</div>



{if $downloads || $series_data}
    <div  class="container content-series-page content-series-onwatch" style="margin-top:20px !important;">
           {if $downloads}
            <div class="container-fluid download-sec">
                <div class="row">
                    <div id="btnServers">
                    <a class="btnDowns" href="{$smarty.const._URL2}/downloads.php?vid={$video_data.uniq_id}" rel="nofollow">
                     اضغط هنا للذهاب الي سيرفرات التحميل 
                    </a>
                </div>
            </div>
        {/if}
	{if $series_data}
            <div class="container-fluid">
                <div class="row">
                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true" style="margin-top:20px !important;">
                        <div class="col-md-12 serie_eps">
                            <div class="mbox">
                                <div class="pda bdb hd">
                                    <right style="font-size: 20px;color: #000000;padding: 5px 10px;margin-top: 10px;font-weight: bold;">المواسم و الحلقات</right>
                                </div>
                                <div class="SeasonsBox">
                                    <div class="SeasonsBoxUL seasons-serie">
                                        <div class="Tab">
                                            {foreach from=$seasons_data key=season_no item=season name=seasons_loop}
                                                
                                                <button  class="tablinks {if {$season} == {$video_data.season}} active {/if}" onclick="openCity(event, '{$lang._season|default:'Season'}{$season_no+1}')">{$season}</button>
                                            {/foreach}
                                        </div>
                                    </div>
                                    <div class="SeasonsEpisodesMain">
                                        <div class="Tab" style="color: black">   
                                            {$seasons_episodes} 

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!--.panel-group-->
                </div>
            </div>
        {/if}
    </div>
</div>
{/if}

<div id="content"> 
<div id="content-main" class="container-fluid">
	<div class="row">

		<div class="col-xs-12 col-sm-12 col-md-12 pm-video-watch-main">
			{if $ad_3 != ''}
			<div class="pm-ads-banner" align="center">{$ad_3}</div>
			{/if}
	
			<div class="row pm-user-header">
				<div class="col-xs-2 col-sm-1 col-md-1">
				   <a href="{$video_data.author_profile_href}"><img src="{$video_data.author_avatar_url}" height="60" width="60" alt="" border="0"></a>
						{if $video_data.author_data.channel_verified == 1 && $smarty.const._MOD_SOCIAL}<a href="#" rel="tooltip" title="{$lang.verified_channel|default:'Verified Channel'}" class="pm-verified-user"><img src="{$smarty.const._URL}/templates/{$smarty.const._TPLFOLDER}/img/ico-verified.png" /></a>{/if}
				</div>

				<div class="col-xs-10 col-sm-11 col-md-11">
					<div class="pm-video-posting-info">{$lang.added} <time datetime="{$video_data.html5_datetime}" title="{$video_data.full_datetime}">{$video_data.time_since_added} {$lang.ago}</time> {$lang._by} <a href="{$video_data.author_profile_href}">{$video_data.author_username}</a></div>
					{if $smarty.const._MOD_SOCIAL && $logged_in == '1' && $video_data.author_user_id != $s_user_id}
						{include file="user-subscribe-button.tpl" profile_data=$video_data profile_user_id=$video_data.author_user_id}
					{/if}
				</div>
				
			</div><!--/.pm-user-header-->

			<div class="clearfix"></div>
			
			<div class="pm-video-description mbox">
                            <div class="pda bdb hd">
                                <right style="font-size: 20px;color: #000000;padding: 5px 10px;margin-top: 10px;font-weight: bold;">الوصف والتفاصيل</right>
                            </div>
                             <div class="description">
				{if !empty($video_data.description)}
				<div itemprop="description">
					{$video_data.description}
				</div>
				{/if}

				<dl class="dl-horizontal">
                                    {if !empty($video_data.series)}
					<dt>المسلسل</dt>
					<dd>{$video_data.series}</dd>
                                    {/if}
                                    {if !empty($video_data.season)}
					<dt>الموسم</dt>
					<dd>{$video_data.season}</dd>
                                    {/if}
                                    {if !empty($category_name)}
                                        <dt>الاقسام</dt>
                                        <dd>{$category_name}</dd>
                                    {/if}
                                    {if !empty($tags)}
                                        <dt>الكلمات المفتاحية</dt>
                                        <dd>{$tags}</dd>
                                    {/if}
				</dl>
			
                            </div>
			</div>

			{include file="comments.tpl" tpl_name="video-watch" allow_comments=$video_data.allow_comments}
		</div><!-- /pm-video-watch-main -->
 

		<div class="clearfix"></div>
	</div>
</div>

{if $collection}

    <div class="container" style="margin-top:10px;">
        <div class="SeasonsBoxUL seasons-on-serie" style="margin-top: 10px"> <p class="seasonEp">{$video_data.collection}</p> </div>
        <ul class="row pm-ul-browse-videos list-unstyled" id="pm-grid">
            {foreach from=$collection key=k item=video_data}
                <li class="col-xs-6 col-sm-4 col-md-3">
                    {include file='item-video-obj.tpl'}
                </li>
            {/foreach}
        </ul>    
    </div>
{/if}                       
                        
{if $related_video_list}
    <div class="container" style="margin-top:10px;">
        <div class="SeasonsBoxUL seasons-on-serie" style="margin-top: 10px"> <p class="seasonEp">قد تود مشاهدتها</p> </div>
        <ul class="row pm-ul-browse-videos list-unstyled" id="pm-grid">
             {foreach from=$related_video_list key=k item=video_data}
                <li class="col-xs-6 col-sm-4 col-md-3">
                    {include file='item-video-obj.tpl'}
                </li>
            {/foreach}
        </ul>    
    </div>
{/if}                     
                        
{include file="modal-video-report.tpl"}
{include file="modal-video-addtoplaylist.tpl"}
{include file='modal-video-share.tpl'}

{include file="footer.tpl" p="detail" tpl_name="video-watch"}